/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.ws.IVWUDDIPanelOperation;
import filenet.vw.toolkit.utils.ws.contact.VWUDDIBusinessContactsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contacts;

public class VWConfigRegionBusinessEntityPanel
extends JPanel
implements ActionListener,
KeyListener,
IVWUDDIPanelOperation {
    private VWUDDIRegistryList m_uddiRegistryList = null;
    private Frame m_parentFrame = null;
    private boolean m_bChanged = false;
    private BusinessEntity m_regionBusinessEntity = null;
    private VWUDDIBusinessContactsPanel m_contactsPanel = null;
    private JTextField m_businessInquiryURLTextField = null;
    private JTextField m_businessNameTextField = null;
    private JTextArea m_businessDescriptionTextArea = null;
    private JTextField m_businessKeyTextField = null;
    private JTextField m_authorizedNameTextField = null;
    private JTextField m_operatorTextField = null;
    private JCheckBox m_enableRegionBusinessEntityCheckBox = null;
    private boolean m_bEnableRegionBusinessEntity = false;
    private Color m_disabledColor;
    private Color m_enabledColor;
    private String m_inquiryURL = null;

    public VWConfigRegionBusinessEntityPanel(Frame parentFrame, VWUDDIRegistryList uddiRegistryList, String inquiryURL) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_inquiryURL = inquiryURL;
            this.m_uddiRegistryList = uddiRegistryList;
            this.m_bEnableRegionBusinessEntity = this.m_uddiRegistryList.getEnableRegionBusinessEntity();
            Contacts regionBusinessContacts = null;
            this.m_regionBusinessEntity = uddiRegistryList.getRegionBusinessEntity();
            regionBusinessContacts = this.m_regionBusinessEntity != null ? this.m_regionBusinessEntity.getContacts() : new Contacts();
            this.m_contactsPanel = new VWUDDIBusinessContactsPanel(this.m_parentFrame, regionBusinessContacts);
            this.createControls();
            this.m_businessInquiryURLTextField.setCaretPosition(0);
            this.m_businessKeyTextField.setCaretPosition(0);
            this.m_businessNameTextField.setCaretPosition(0);
            this.m_authorizedNameTextField.setCaretPosition(0);
            this.m_operatorTextField.setCaretPosition(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_bChanged || this.m_contactsPanel.hasChanged();
    }

    public void stopEditing() {
        this.m_contactsPanel.stopEditing();
    }

    public boolean validateData() {
        if (this.m_bEnableRegionBusinessEntity) {
            String tmpStr = this.m_businessNameTextField.getText();
            if (tmpStr == null || tmpStr.length() < 1) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.RegionBusinessNameInvalid, VWResource.ErrorMessage, 1);
                return false;
            }
            tmpStr = this.m_authorizedNameTextField.getText();
            if (tmpStr == null || tmpStr.length() < 1) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.RegionBusinessAuthorizedNameInvalid, VWResource.ErrorMessage, 1);
                return false;
            }
            tmpStr = this.m_operatorTextField.getText();
            if (tmpStr == null || tmpStr.length() < 1) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.RegionBusinessOperatorInvalid, VWResource.ErrorMessage, 1);
                return false;
            }
            return this.m_contactsPanel.verifyContacts();
        }
        return true;
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            if (this.m_bChanged) {
                this.m_uddiRegistryList.setEnableRegionBusinessEntity(this.m_bEnableRegionBusinessEntity);
                bSuccess = this.validateData();
                if (bSuccess) {
                    Vector<Object> v = new Vector<Object>();
                    v.add(new Name(this.m_businessNameTextField.getText()));
                    this.m_regionBusinessEntity.setNameVector(v);
                    v = new Vector();
                    v.add(new Description(this.m_businessDescriptionTextArea.getText()));
                    this.m_regionBusinessEntity.setDescriptionVector(v);
                    this.m_regionBusinessEntity.setAuthorizedName(this.m_authorizedNameTextField.getText());
                    this.m_regionBusinessEntity.setOperator(this.m_operatorTextField.getText());
                }
            }
            if (bSuccess && this.m_contactsPanel.hasChanged() && (bSuccess = this.m_contactsPanel.verifyContacts())) {
                Contacts contactList = this.m_contactsPanel.getContacts();
                this.m_regionBusinessEntity.setContacts(contactList);
                this.m_bChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
        return bSuccess;
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.add((Component)this.createInfoPanel(), "First");
            this.add((Component)this.m_contactsPanel, "Center");
            this.enableControls(this.m_bEnableRegionBusinessEntity);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_uddiRegistryList != null) {
            this.m_uddiRegistryList.releaseResources();
            this.m_uddiRegistryList = null;
        }
        this.m_contactsPanel.releaseResources();
        this.m_contactsPanel = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_enableRegionBusinessEntityCheckBox) {
            this.m_bEnableRegionBusinessEntity = this.m_enableRegionBusinessEntityCheckBox.isSelected();
            this.enableControls(this.m_bEnableRegionBusinessEntity);
            this.m_bChanged = true;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.m_bChanged = true;
    }

    private JPanel createInfoPanel() {
        try {
            JPanel mainPanel = new JPanel();
            String text = "";
            Vector v = null;
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 21;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            this.m_enableRegionBusinessEntityCheckBox = new JCheckBox(VWResource.EnableRegionBusinessEntity);
            this.m_enableRegionBusinessEntityCheckBox.setSelected(this.m_bEnableRegionBusinessEntity);
            this.m_enableRegionBusinessEntityCheckBox.addActionListener(this);
            mainPanel.add((Component)this.m_enableRegionBusinessEntityCheckBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_enableRegionBusinessEntityCheckBox, this, VWResource.EnableRegionBusinessEntity, VWResource.EnableRegionBusinessEntity);
            this.m_enableRegionBusinessEntityCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.gridx = 2;
            gbConst.gridwidth = 1;
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.InquiryURL));
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.InquiryURL, VWResource.InquiryURL);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_businessInquiryURLTextField = new JTextField();
            this.m_businessInquiryURLTextField.setEditable(false);
            if (this.m_inquiryURL != null) {
                this.m_businessInquiryURLTextField.setText(this.m_inquiryURL);
            }
            mainPanel.add((Component)this.m_businessInquiryURLTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_businessInquiryURLTextField, this, VWResource.UDDIRegionBusinessInqueryURL, VWResource.UDDIRegionBusinessInqueryURL);
            VWAccessibilityHelper.setLabelFor(label, this.m_businessInquiryURLTextField);
            this.m_businessInquiryURLTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 0.0;
            label = new JLabel(VWResource.s_label.toString(VWResource.s_businessName));
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_businessName, VWResource.s_businessName);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            v = this.m_regionBusinessEntity.getNameVector();
            if (v != null && v.size() > 0 && v.elementAt(0) != null && v.elementAt(0) instanceof Name) {
                text = ((Name)v.elementAt(0)).getValue();
            }
            this.m_businessNameTextField = new JTextField(text);
            this.m_businessNameTextField.addKeyListener(this);
            mainPanel.add((Component)this.m_businessNameTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_businessNameTextField, this, VWResource.UDDIRegionBusinessNameField, VWResource.UDDIRegionBusinessNameField);
            VWAccessibilityHelper.setLabelFor(label, this.m_businessNameTextField);
            this.m_businessNameTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            JLabel keyLabel = new JLabel(VWResource.s_label.toString(VWResource.s_businessKey));
            mainPanel.add((Component)keyLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(keyLabel, this, VWResource.s_businessKey, VWResource.s_businessKey);
            keyLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_businessKeyTextField = new JTextField(this.m_regionBusinessEntity.getBusinessKey());
            this.m_businessKeyTextField.setEditable(false);
            mainPanel.add((Component)this.m_businessKeyTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_businessKeyTextField, this, VWResource.s_businessKey, VWResource.s_businessKey);
            VWAccessibilityHelper.setLabelFor(keyLabel, this.m_businessKeyTextField);
            this.m_businessKeyTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            JLabel authorizedNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_authorizedName));
            mainPanel.add((Component)authorizedNameLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(authorizedNameLabel, this, VWResource.s_authorizedName, VWResource.s_authorizedName);
            authorizedNameLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_authorizedNameTextField = new JTextField(this.m_regionBusinessEntity.getAuthorizedName());
            this.m_authorizedNameTextField.addKeyListener(this);
            mainPanel.add((Component)this.m_authorizedNameTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_authorizedNameTextField, this, VWResource.UDDIAuthorizedNameField, VWResource.UDDIAuthorizedNameField);
            VWAccessibilityHelper.setLabelFor(authorizedNameLabel, this.m_authorizedNameTextField);
            this.m_authorizedNameTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            JLabel operatorLabel = new JLabel(VWResource.s_operator);
            mainPanel.add((Component)operatorLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(operatorLabel, this, VWResource.s_operator, VWResource.s_operator);
            operatorLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_operatorTextField = new JTextField(this.m_regionBusinessEntity.getOperator());
            this.m_operatorTextField.addKeyListener(this);
            mainPanel.add((Component)this.m_operatorTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_operatorTextField, this, VWResource.UDDIOperatorNameField, VWResource.UDDIOperatorNameField);
            VWAccessibilityHelper.setLabelFor(operatorLabel, this.m_operatorTextField);
            this.m_operatorTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.anchor = 23;
            JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_businessDescription));
            mainPanel.add((Component)descriptionLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.s_businessDescription, VWResource.s_businessDescription);
            descriptionLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.fill = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.gridwidth = 0;
            v = this.m_regionBusinessEntity.getDescriptionVector();
            text = "";
            if (v != null && v.size() > 0 && v.elementAt(0) != null && v.elementAt(0) instanceof Description) {
                text = ((Description)v.elementAt(0)).getValue();
            }
            this.m_businessDescriptionTextArea = new JTextArea(text);
            this.m_businessDescriptionTextArea.setRows(3);
            this.m_businessDescriptionTextArea.setLineWrap(true);
            this.m_businessDescriptionTextArea.setWrapStyleWord(true);
            this.m_businessDescriptionTextArea.addKeyListener(this);
            mainPanel.add((Component)new JScrollPane(this.m_businessDescriptionTextArea), gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_businessDescriptionTextArea, this, VWResource.UDDIDescriptionTextArea, VWResource.UDDIDescriptionTextArea);
            VWAccessibilityHelper.setLabelFor(descriptionLabel, this.m_businessDescriptionTextArea);
            this.m_businessDescriptionTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_enabledColor = this.m_businessDescriptionTextArea.getBackground();
            this.m_disabledColor = mainPanel.getBackground();
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void enableControls(boolean bEnable) {
        this.m_businessNameTextField.setEditable(bEnable);
        this.m_businessDescriptionTextArea.setEditable(bEnable);
        this.m_authorizedNameTextField.setEditable(bEnable);
        this.m_operatorTextField.setEditable(bEnable);
        this.m_contactsPanel.enableControls(bEnable);
        if (bEnable) {
            this.m_businessDescriptionTextArea.setBackground(this.m_enabledColor);
        } else {
            this.m_businessDescriptionTextArea.setBackground(this.m_disabledColor);
        }
    }
}

